using System;
using Server;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class DridersChitinFragment : BaseTalisman
	{
		public override bool ForceShowName{ get{ return true; } }
		
		[Constructable]
		public DridersChitinFragment() : base( 12120 )
		{
			Hue = Utility.RandomNeutralHue();
			Name = "<basefont color=#FF6600>Drider's chitin fragment";
// 			Blessed = RandomTalisman.GetRandomBlessed();
			Protection = new TalismanAttribute( typeof( Drider ), 30, "Drider" );
			Killer = new TalismanAttribute( typeof( Drider ), Utility.RandomMinMax( 20, 50 ), "Drider" );
         Slayer = TalismanSlayerName.Vermin;
			MaxChargeTime = 1800;
			MaxCharges = Utility.RandomMinMax( 40, 50 );
			Charges = MaxCharges;
			Summoner = new TalismanAttribute( typeof( Ribs ), 3, 1022546 );
			
			Skill = SkillName.Tailoring;
			ExceptionalBonus = Utility.RandomMinMax( 20, 40 );
			SuccessBonus = Utility.RandomMinMax( 20, 40 );
			
			SkillBonuses.SetValues( 2, SkillName.Anatomy, 15.0 );
			SkillBonuses.SetValues( 3, SkillName.Healing, 15.0 );
			Attributes.Luck = 150;
			Attributes.BonusHits = 20;
			Attributes.AttackChance = 30;
			Attributes.DefendChance = 10;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#FF6600>Immunity to acid<basefont color=White>" );
		}
		
		public DridersChitinFragment( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
